(*| 11:10 26/07/1996 *)
PROGRAM CheckSum;

USES
  Dos;

CONST
  HexAscii:ARRAY[0..15] OF CHAR = '0123456789ABCDEF';

  BufferSize = $6000;

VAR
  SR: SearchRec;
  ThisFileName : String;
  FDir: DirStr;
  FName: NameStr;
  FExt: ExtStr;
  FoundEof : Boolean;
  NumRead : Word;
  CSum : Word;
  I,Block,InsertCount : Integer;
  Buffer : Array[1..BufferSize] OF Byte;

FUNCTION HexString(W: Word): String;
VAR
  I : Integer;
  C : Char;
  S : String[4];
BEGIN
  S := '';
  FOR I := 1 TO 4 DO BEGIN
    C := HexAscii[W AND $000F];
    S := C + S;
    W := W SHR 4;
  END;
  HexString := S;
END;

FUNCTION HexByteString(B: Byte): String;
VAR
  I : Integer;
  C : Char;
  S : String[2];
BEGIN
  S := '';
  FOR I := 1 TO 2 DO BEGIN
    C := HexAscii[B AND $0F];
    S := C + S;
    B := B SHR 4;
  END;
  HexByteString := S;
END;

PROCEDURE UpCaseString(VAR S: String);
VAR
  I:Integer;
BEGIN
  FOR I := 1 TO Length(S) DO
    S[I] := UpCase(S[I]);
END;

PROCEDURE Process(SrcFileName: String);
VAR
  I : Integer;
  Src: File;

  PROCEDURE NextBlock;
  BEGIN
    BlockRead(Src, Buffer, BufferSize, NumRead);
    IF NumRead = 0 THEN
      FoundEof := True;
  END;

BEGIN
  IF SrcFileName <> ThisFileName THEN
    Writeln('Source File Name : ',SrcFileName);
  Assign(Src, SrcFileName);
{$I-}
  Reset(Src,1);
{$I+}
  IF IOResult <> 0 THEN BEGIN
    Writeln('ABORTING, unable to open ',SrcFileName);
    Halt(1);
  END;
  CSum := 0;
  REPEAT
    NextBlock;
    IF NumRead > 0 THEN
      FOR I := 1 TO NumRead DO
        INC(CSum, Buffer[I]);
  UNTIL FoundEof;
  Write('Checksum is : ',CSum,',  ',HexString(CSum),'h');
  IF (CSum AND $00FF) <> 0 THEN
    Write('  Correction : ',HexByteString($100 - CSum),'h');
  Writeln;
  Close(Src);
END;

BEGIN
  Writeln('Checksum program by B Whitnall, v1.3');
  FoundEof := False;
  IF ParamCount > 0 THEN
    ThisFileName := ParamStr(1)
  ELSE BEGIN
    Write('Source File name : ');
    Readln(ThisFileName);
  END;
  UpCaseString(ThisFileName);
  FSplit(ThisFileName,FDir,FName,FExt);
  FindFirst(ThisFileName,AnyFile,SR);
  WHILE DosError = 0 DO BEGIN
    Process(FDir+SR.Name);
    FindNext(SR);
  END;
END.
